/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *	             GNU/linux version 3.4.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2003,2004,2005,2006,2007,2008,2009,2012 COLLARD Christophe
 * copyright © 2003,2004,2005,2006,2007,2008,2009,2012 Centre National de la Recherche Scientifique
 * copyright © 2003,2004,2005,2006,2007,2008,2009 Arts et Métiers ParisTech
 * copyright © 2003,2004,2005,2006,2007 Université de Valenciennes et du Hainaut-Cambrésis
 * copyright © 2003,2004,2005,2006,2007,2008,2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2003,2004,2005,2006,2007 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV)
 * copyright © 2010,2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    conversion tools-test belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type conversion tools-test
#endif

#ifndef __conversion_tools_test_hpp
#define __conversion_tools_test_hpp


#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __colors_hpp
#include "colors.hpp"
#endif

#ifndef __matrix_hpp
#include "MOL++/matrix.hpp"
#endif

#ifndef __tensors4_hpp
#include "MOL++/tensors4.hpp"
#endif

#ifndef __symtensors2_hpp
#include "MOL++/symtensors2.hpp"
#endif

#ifndef __conversion_tools_hpp
#include "MOL++/conversion tools.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace mol;


//====================================
int test_conversion_tools (int detail)
//====================================
{
  int result=1;

  matrix<float> mat(3,27);
  vector<float> v(81);
  int n=1;
  for (int i=1; i<=3; i++)
    for (int j=1; j<=27; j++)
      v[n++] = mat(i,j) = 5*i -3*j;
  if (detail) affiche("matrix2vector", v==matrix2vector(mat));
  else result *= (v==matrix2vector(mat));

  if (detail) affiche("vector2matrix", mat==vector2matrix(matrix2vector(mat),3,27) && (mat|mat)==v*v);
  else result *= (mat==vector2matrix(matrix2vector(mat),3,27) && (mat|mat)==v*v);

  tensor4<float> tsr(3,27,5,8);
  matrix<float> mat2(5,8);
  for (int i=1; i<=5; i++)
    for (int j=1; j<=8; j++)
	   mat2(i,j) = 2.5*i - 5*j;
  for (int i=1; i<=3; i++)
    for (int j=1; j<=27; j++)
      for (int k=1; k<=5; k++)
	for (int l=1; l<=8; l++)
	  tsr(i,j,k,l) = 5*i + 3*j - 2*k/l;
  if (detail) affiche("tensor2matrix", (tsr||(tensor2<float>)mat2)==vector2matrix(tensor2matrix(tsr)*matrix2vector(mat2),3,27) );
  else result *= ((tsr||(tensor2<float>)mat2)==vector2matrix(tensor2matrix(tsr)*matrix2vector(mat2),3,27) );

  if (detail) affiche("matrix2tensor", tsr == matrix2tensor(tensor2matrix(tsr),3,27,5,8) );
  else result *= (tsr == matrix2tensor(tensor2matrix(tsr),3,27,5,8));

  tensor2<long double> t2sr(4);
  for (int i=1; i<=4; i++)
    for (int j=i; j<=4; j++)
      t2sr (i,j) = t2sr(j,i) = i*pi()+2*j;
  vector<long double>  v2sr = symtensor2vector((symtensor2<long double>)t2sr);
  if (detail) affiche("symtensor2vector", abs( (t2sr|t2sr) - v2sr*v2sr) < epsilon);
  else result *= (abs( (t2sr|t2sr) - v2sr*v2sr) < epsilon);

  if (detail) affiche("vector2symtensor", vector2symtensor(v2sr) == t2sr);
  else result *= (vector2symtensor(v2sr) == t2sr);

  tensor4<long double> ts(5,5,7,7), st(7,7,3,3);
  for (int i=1; i<=5; i++)
    for (int j=i; j<=5; j++)
      for (int k=1; k<=7; k++)
	for (int l=k; l<=7; l++)
	  ts(i,j,k,l) = ts(i,j,l,k) = ts(j,i,k,l) = ts(j,i,l,k) = l + 2*k - 3*i * .5*j;
  for (int i=1; i<=7; i++)
    for (int j=i; j<=7; j++)
      for (int k=1; k<=3; k++)
	for (int l=k; l<=3; l++)
	  st(i,j,k,l) = st(i,j,l,k) = st(j,i,k,l) = st(j,i,l,k) = .9*l - 2*k - 5*i / j;
  matrix<long double> mts =& symtensor2matrix(ts), mst =& symtensor2matrix(st);
  tensor2<long double> N(5), R(7);
  for (int i=1; i<=7; i++)
    for (int j=i; j<=7; j++)
      { if (i<=5 && j<=5) N(i,j) = N(j,i) = pi() * i - j;
	R(i,j) = R(j,i) = i / (1.*j);
      }
  vector<long double> vn =& symtensor2vector((symtensor2<long double>) N), vr =& symtensor2vector((symtensor2<long double>) R);
  //  cout << (ts||R);
  //  cout << vector2symtensor(mts*vr);
  if (detail) affiche("symtensor2matrix", abs((N | (ts || R)) - vn * mts * vr) < 3*epsilon && (ts||R)==vector2symtensor(mts*vr) && symtensor2matrix(ts||st) == mts*mst);
  else result *= (abs((N | (ts || R)) - vn * mts * vr) < 3*epsilon && (ts||R)==vector2symtensor(mts*vr) && symtensor2matrix(ts||st) == mts*mst);

  if (detail) affiche("matrix2symtensor", matrix2symtensor(mts) == ts);
  else result *= (matrix2symtensor(mts) == ts);

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout << green << "               conversion tools test passed" << reset;
  else cout << red << "               conversion tools test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
